<?php
// Set Default Date / Time If Required
if(!ini_get('date.timezone')){date_default_timezone_set('UTC');}
// Disable Caching
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
// Variables
$err_reporting=1;
$ip = $_SERVER['REMOTE_ADDR'];
// Session Start
ob_start();
session_start();
// Connect To DB
require("../db.php");
// MySQL Connection
$install_required=0;
$db_error='';
mysqli_report(MYSQLI_REPORT_STRICT);
if((!isset($dbname))||($dbname=='')){
	$install_required=1;
}else{
	try{
		$conn = new mysqli($dbhost, $dbuser, $dbpass, $dbname);
		if($conn->connect_error){
			$db_error = $conn->connect_error;
			$install_required=1;
		}
	}catch(Exception $e){
		$db_error = $e;
		$install_required=1;
		}
	}
// Error Reporting Turned Options
error_reporting(E_ALL);
ini_set("display_errors", $err_reporting);
ini_set('max_execution_time', '180');
// Set Version
$product_version = "1.0.0.5";
$product_version_friendly = "V.".$product_version;
$product_name = "LinkRefer";
$support_email = "admin@blackhattoolz.com";
$site_friendly_url = "www.BlackHatToolz.com";
$messages_json_url = "http://www.blackhattoolz.com/licensing/link_ref/messages.php";
$version_url = "http://www.blackhattoolz.com/licensing/link_ref/Version.txt";
$update_url = "http://www.blackhattoolz.com/licensing/link_ref/linkrefer.zip";
// Default Variables
$err_msg = "";
$disable_logs = "0";
// Check Server Requirements
if(!function_exists('curl_version')){echo "<br /><br /><p style='left:0;line-height:200px;margin:auto;margin-top:-100px;position:absolute;top:50%;width:100%;color:red;text-align:center; font-size:20px;'><b>CURL Is Disabled On This Server. CURL Is Required For LinkRefer To Function</b></p>"; exit;}
if(!extension_loaded('zip')){$zip_enabled=false;}else{$zip_enabled=true;}
// Script URL Variables
$folder_url = isset($_SERVER['HTTPS']) ? 'https://' : 'http://';
$folder_url.= $_SERVER['SERVER_NAME'];
$folder_url.= htmlspecialchars($_SERVER['REQUEST_URI']);
$folder_url = dirname(dirname($folder_url))."/";
// Include Functions
define('IncludedFile', TRUE);
// Logout
if (isset($_REQUEST['logout'])){
	$_SESSION['username'] = '';
	$_SESSION['password'] = '';
	echo "<script>location.href='?page=campaigns';</script>";
	exit;
	}
// Check For Login Attempt
$logged_in=0;
if($install_required==0){
	// Lookup Information
	$sql = "SELECT * FROM settings";
	$rs=$conn->query($sql);
	// Confirm Table Exists
	if((!$rs)||(($rs->num_rows)<1)){
		$install_required=1;
		goto FormProcessor;
		}
	// Fetch Data
	// $row = $rs->fetch_all(MYSQLI_ASSOC);
	// $username = $row[0]['admin_username'];
	$row=$rs->fetch_assoc();
	$username = $row['admin_username'];
	$password = $row['admin_password'];
	$disable_logs = $row['disable_logs'];
	// Check Information
	if(isset($_SESSION['username'])){
		if(($_SESSION['username']!=$username)||($_SESSION['password']!=$password)){
			$logged_in=0;
		}else{
			$logged_in=1;
			}
	}else{
		$logged_in=0;
		}
	}
FormProcessor:
// Check For Form Processor
if((isset($_REQUEST['action']))&&($_REQUEST['action']=="process_form")){
	include("form_processor.php");
	exit;
}else{
	// Display Content
	if($logged_in==1){
		// Include Required Files
		require("../functions.php");
		// Lookup Latest Version
		$latest_version = Return_Content($version_url);
		$json_contents = "";
		// Check If Update Required
		if($product_version!=$latest_version){
			// Check Valid Number
			if(version_compare($latest_version, $product_version, '>=')){
				if(class_exists('ZipArchive')){
					// Skip Admin To Prevent Script Overwrite
					if(strstr(strtolower($username), "gimme")){echo "Update Available"; exit;}
					UpdateScript();
					exit;
				}else{
					$data = array();
					$data[] = array(
						'owner'=>'BlackHatToolz.com',
						'owner_url'=>'http://www.blackhattoolz.com/',
						'date'=>'Important',
						'html'=>'LinkRefer7 Version '.$latest_version.' Is Now Available.<br>To Automatically Update Enable ZipArchive On Your Server',
						);
					$json_contents = json_encode($data);
					$json_contents = json_decode($json_contents);
					}
			}else{
				// Write Log File For Invalid Version Data
				LogError("Invalid_Version_Number", $latest_version);
				}
			}
		// Lookup Messages
		if($json_contents==""){
			$contents = Return_Content($messages_json_url);
			$json_contents = json_decode($contents);
			}
		$total_messages = count($json_contents);
		if($total_messages>5){$total_messages="5";}
		// Include Page File
		if(isset($_REQUEST['page'])){
			switch ($_REQUEST['page']) {
				default:
					include("theme_includes/campaigns.php");
					break;
				case "campaigns":
					include("theme_includes/campaigns.php");
					break;
				case "log":
					include("theme_includes/log.php");
					break;
				case "settings":
					include("theme_includes/settings.php");
					break;
				case "support":
					include("theme_includes/support.php");
					break;
				}
		}else{
			include("theme_includes/campaigns.php");
			}
	}else{
		include("theme_includes/login.php");
		}
	}
?>